/**********************************************************************
*
* debug.c -- Version 3.0
*
* Developer Technical Support Apple II Sample Code
*
* Copyright (c)
* Apple Computer, Inc.  1988-1990
* All Rights Reserved.
*
* Written by Eric Soldan.
*
**********************************************************************/

/* This file contains some simple, yet useful debugging routines
** for c programmers.  This code is conditionally included.  It
** depends on productionVersion being 0.  If productionVersion = 0,
** then the code is included.  You want to make sure that the code is
** not included in the production version because this code calls
** sprintf and sprintf is HUGE.  Your program will be about 20k
** smaller without sprintf.
*/

/**********************************************************************/
/**********************************************************************/
/**********************************************************************/

#include <quickdraw.h>
#include <texttool.h>
#include "lister.h"

char    test[80];

#if 1
#else

/**********************************************************************/

/* This code waits for something to be done with the paddle buttons.
** The openApple and option keys can be used as the buttons.
** When either the openApple or option key is pressed, the super
** hi-res screen is displayed.  Depending on which was pressed, one
** of two things occurs when it is released.  If the option key was
** pressed, then the text screen is displayed again, and it again
** waits for a paddle button to be pressed.  This allows you to 
** jump between the text screen and the super hi-res screen.  If the
** openApple key was pressed, then when it is released, the routine 
** returns.  This is the key to be used to continue your application.
** If both the openApple and option key are pressed, then it returns
** immediately.  It does not wait for a key to be released.
*/

void    pdlWait()
{
    unsigned int    i;

    for (;;) {
        GrafOff();
        for (;;) {
            for (i = 2; i; i--) {
                if (*((char *)(0xE0C060 + i)) & 0x80) break;
            }
            if (i) break;
        }
        GrafOn();
        for (; *((char *)(0xE0C060 + i)) & 0x80;) {
            if (*((char *)(0xE0C063 - i)) & 0x80) return;
        }
        if (i == 1) return;
    }
}

/**********************************************************************/

/* This routine displays a string on the text screen if the openApple
** key is not being held down.
*/

void    sbug(str)
char    *str;
{
    if (*((char *)0xE0C061) >= 0x80) return;
    InitTextDev(1);
    WriteCString(str);
    pdlWait();
}

/**********************************************************************/

/* This routine displays the stack pointer at the point in your
** application when you call it.  This is useful to determine if
** you have some stack inbalance in a particular routine, and if
** so, where it is.
*/

void    stack()
{
    unsigned int    stk;

    asm {
        tsc
        clc
        adc #13
        sta stk
    }
    sprintf(test, "stack=$%X", stk);
    sbug(test);
}

#endif
